% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{stackdata}
\alias{stackdata}
\title{Combine \code{data.frame}s}
\usage{
stackdata(...)
}
\arguments{
\item{...}{\code{data.frame}s or objects that can be coerced to
\code{data.frame}s}
}
\value{
A stacked \code{data.frame}
}
\description{
Combine \code{data.frame}s
}
\details{
This function combines \code{data.frame}s by filling in missing
variables with \code{NA}. This is useful for combining data from
sampled locations with prediction locations.
}
\examples{
\dontrun{
  data(rhizoctonia)

  predgrid <- mkpredgrid2d(rhizoctonia[c("Xcoord", "Ycoord")],
                           par.x = 100, chull = TRUE, exf = 1.2)
  rhizdata <- stackdata(rhizoctonia, predgrid$grid)
}
}

