% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{update_finite_infinity_for_uniform}
\alias{update_finite_infinity_for_uniform}
\title{Maximum between finite_infinity and 10 times the max abs value of finite elements in \code{lefts} and \code{rights}.}
\usage{
update_finite_infinity_for_uniform(lefts, rights, finite_infinity)
}
\arguments{
\item{lefts}{A non-empty vector of numbers (may contain \code{-Inf}), the left endpoints of a domain defined as a union of intervals. Must pass \code{check_endpoints(lefts, rights)}.}

\item{rights}{A non-empty vector of numbers (may contain \code{Inf}), the right endpoints of a domain defined as a union of intervals. Must pass \code{check_endpoints(lefts, rights)}.}

\item{finite_infinity}{A finite positive number. \code{Inf} will be truncated to \code{finite_infinity} if applicable. See details.}
}
\value{
A double, larger than or equal to \code{finite_infinity}.
}
\description{
Maximum between \code{finite_infinity} and 10 times the max abs value of finite elements in \code{lefts} and \code{rights}.
}
\details{
Since we assume that \code{lefts[i] <= rights[i] <= lefts[j]} for any \code{i < j}, the function takes the maximum between \code{finite_infinity} and 10 times the absolute values of \code{lefts[1]}, \code{lefts[length(lefts)]}, \code{rights[1]}, and \code{rights[length(rights)]}, if they are finite.
}
\examples{
# Does not change since 1000 > 12 * 10
update_finite_infinity_for_uniform(c(-10,-5,0,5,9), c(-8,-3,2,7,12), 1000)
# Changed to 12 * 10
update_finite_infinity_for_uniform(c(-10,-5,0,5,9), c(-8,-3,2,7,12), 10)
# Changed to 12 * 10
update_finite_infinity_for_uniform(c(-Inf,-5,0,5,9), c(-8,-3,2,7,12), 10)
# Changed to 9 * 10
update_finite_infinity_for_uniform(c(-Inf,-5,0,5,9), c(-8,-3,2,7,Inf), 10)
}
