% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_in_illumina_GoldenGate.R
\name{read_in_illumina_GoldenGate}
\alias{read_in_illumina_GoldenGate}
\title{Read in Illumina GoldenGate AB tab delimited text file}
\usage{
read_in_illumina_GoldenGate(tab_delimited_file, chromosome,
  flanking_region_length)
}
\arguments{
\item{tab_delimited_file}{is a tab delimited AB illumina GoldenGate file}

\item{chromosome}{is a vector of chromosome names}

\item{flanking_region_length}{is the length in bp of the flanking region of the SNP}
}
\value{
data frame useful used in genotypeR
}
\description{
\code{read_in_illumina_GoldenGate} reads in a tab delimited
output file from illumina GoldenGate SNP genotyping platform for
use in genotypeR.
}
\examples{
\dontrun{
test_data <- read_in_illumina_GoldenGate(tab_delimited_file= \\
"path_to_golden_gate_file", flanking_region_length=50,  \\
chromosome=rep("chr2", length.out=length(552960)))
}
}
\keyword{GoldenGate}
\keyword{illumina}
