% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoldenGate2iCOM_design.R
\name{GoldenGate2iCOM_design}
\alias{GoldenGate2iCOM_design}
\title{Output GoldenGate markers for assay development with illumina iCOM}
\usage{
GoldenGate2iCOM_design(SequenomMarkers, Target_Type = "SNP",
  Genome_Build_Version = "0", Chromosome = "0", Coordinate = "0",
  Source = "unknown", Source_Version = "0",
  Sequence_Orientation = "unknown", Plus_Minus = "Plus")
}
\arguments{
\item{SequenomMarkers}{maker data frame from make SequenomMarkers}

\item{Target_Type}{SNP/Indel}

\item{Genome_Build_Version}{genome build version (number; default 0)}

\item{Chromosome}{(default 0)}

\item{Coordinate}{genomic coordinate (default 0)}

\item{Source}{unknown/sequence information (default "unknown")}

\item{Source_Version}{number (default 0)}

\item{Sequence_Orientation}{"forward", "reverse", "unknown" (default "unknown")}

\item{Plus_Minus}{strand orientation "Plus" or "Minus" (default "Plus")}
}
\value{
A data frame suited for the genotypeR package
}
\description{
\code{GoldenGate2iCOM_design} outputs GoldenGate markers for
SNP genotyping assay development with illumina iCOM.
}
\examples{

library(genotypeR)
data(markers)
SequenomMarkers <- markers
##this is to reduce the marker lengths to 50 bp flanking SNP
SequenomMarkers$marker <- substr(markers$marker, 51, 155)
GG_SNPs <- GoldenGate2iCOM_design(SequenomMarkers)
write.csv(GG_SNPs, "test.csv", row.names=FALSE)

}
\keyword{Sequenom}
\keyword{read}
