% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnrichAdv.R
\name{plotEnrichAdv}
\alias{plotEnrichAdv}
\title{Advanced Plot for GO and KEGG enrichment analysis
Both up and down regulated pathways could be plotted in one figure as two-side barplot}
\usage{
plotEnrichAdv(
  up_enrich_df,
  down_enrich_df,
  plot_type = c("one", "two"),
  term_metric = c("FoldEnrich", "GeneRatio", "Count", "RichFactor"),
  stats_metric = c("p.adjust", "pvalue", "qvalue"),
  wrap_length = NULL,
  xlim_left = NULL,
  xlim_right = NULL,
  color,
  ...
)
}
\arguments{
\item{up_enrich_df}{Enrichment analysis `data.frame` for up-regulated genes.}

\item{down_enrich_df}{Enrichment analysis `data.frame` for down-regulated genes.}

\item{plot_type}{Choose from "one" and "two". "One" represents both up and down pathways are plotted
together; "two" represents up and down are plotted seperately.}

\item{term_metric}{Pathway term metric from one of 'GeneRatio','Count','FoldEnrich' and
'RichFactor'.}

\item{stats_metric}{Statistic metric from one of "pvalue", "p.adjust", "qvalue".}

\item{wrap_length}{Numeric, wrap text if longer than this length. Default is NULL.}

\item{xlim_left}{X-axis left limit}

\item{xlim_right}{X-axis right limit}

\item{color}{Plot colors.}

\item{...}{other arguments from `plot_theme` function}
}
\value{
A ggplot object
}
\description{
Advanced Plot for GO and KEGG enrichment analysis
Both up and down regulated pathways could be plotted in one figure as two-side barplot
}
