% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{write.hap}
\alias{write.hap}
\title{Save Haplotype Results to Disk}
\usage{
write.hap(x, file = file, sep = "\t")
}
\arguments{
\item{x}{objec of hapResult or hapSummary class}

\item{file}{file path, where to save the hap result/summary}

\item{sep}{the field separator string. Values within each row of x are separated by this string.
Default as "\verb{\\t}"}
}
\value{
No return value
}
\description{
This function will write hap result into a txt file.
}
\details{
The hap result and hap summary result have common features.
The common features of these two types are:
First four rows contains extra information: CHR, POS, INFO and ALLELE
Hap names were in the first column.
The differences are:
Hap summary result have a freq column while hap result not.
Rows represent haplotypes in hap summary result, while rows represent accessions in hap result.
In addtion, the accessions of each haplotype in hap summary result were separated by ";".
}
\examples{


oriDir <- getwd()
setwd(tempdir())
data("geneHapR_test")
write.hap(hapResult, file = "hapResult.txt")
setwd(oriDir)

}
