% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_richness}
\alias{plot_richness}
\title{Plot the richness of the given list of species on a landscape}
\usage{
plot_richness(species_list, landscape)
}
\arguments{
\item{species_list}{a list of species to use in the richness calculation}

\item{landscape}{a corresponding landscape object}
}
\description{
Plot the richness of the given list of species on a landscape
}
\examples{
## plot from saved outputs
# get path containing example rasters
datapath <- system.file(file.path("extdata", "WorldCenter"), package="gen3sis")
# get species at t0
species_t_0 <- readRDS(file.path(datapath, 
                        "output/config_worldcenter/species/species_t_0.rds"))
# get landscape at t0
landscape_t_0 <- readRDS(file.path(datapath, 
                          "output/config_worldcenter/landscapes/landscape_t_0.rds"))
# plot richness
plot_richness(species_t_0, landscape_t_0)


## plot from within observer
# call plot_richness from inside the end_of_timestep_observer function 
# at the config file:
\dontrun{
plot_richness(data$all_species, data$landscape)
} 
}
