% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confints.R
\name{confints}
\alias{confints}
\alias{plot.confints}
\alias{confints.default}
\alias{confints.GEM}
\title{Confidence Intervals of Effect Differences}
\usage{
confints(X1, ...)

\method{confints}{default}(X1, X2, confidence = 0.95, df.used = 0, ...)

\method{confints}{GEM}(
  X1,
  factor = 1,
  levels = c(1, 2),
  confidence = 0.95,
  df.used = X1$df.used,
  ...
)

\method{plot}{confints}(
  x,
  y,
  xlab = "",
  ylab = "values",
  sorted = TRUE,
  labels = FALSE,
  nonZero = FALSE,
  xlim = NULL,
  ylim = NULL,
  text.pt = 12,
  ...
)
}
\arguments{
\item{X1}{\code{data.frame} containing first effect or \code{GEM} object for ER matrix based intervals.}

\item{...}{Further arguments to \code{qplot}.}

\item{X2}{\code{data.frame} containing second effect.}

\item{confidence}{Level of confidence, default = 0.95.}

\item{df.used}{Optional argument indicating how many degrees of freedom have been consumed during deflation. Default = 0.}

\item{factor}{(\code{character} or \code{numeric}) indicating which factor to use in ER based intervals (defaul = 1).}

\item{levels}{\code{vector} (\code{character} or \code{numeric}) indicating which factor levels to. use in ER based intervals (default = c(1,2)).}

\item{x}{Object of class \code{confint}.}

\item{y}{Not used.}

\item{xlab}{X label (\code{character})}

\item{ylab}{Y label (\code{character})}

\item{sorted}{Logical indicating if intervals should be sorted according to their mean values, or a vector of indices/labels to sort by.}

\item{labels}{Logical indicating if sample labels should be used on x axis.}

\item{nonZero}{Logical indicating if intervals are required not to include zero.}

\item{xlim}{Limits of the horizontal scale.}

\item{ylim}{Limits of the vertical scale.}

\item{text.pt}{Size scaling of text in the plot (default = 16).}
}
\value{
An object of class \code{confints}, which holds
the information needed to perform statistics or plot the
confidence intervals is returned from \code{confints}.
The plotting routine returns a ggplot structure for plotting.
}
\description{
Confidence Intervals of Effect Differences
}
\examples{
data(MS)
# Subset to reduce runtime in example
MS$proteins <- MS$proteins[,20:70]

# Compare MS and non-MS patients within group 1
conf <- with(MS, confints(proteins[MS == "yes" & group == 1,],
                          proteins[MS == "no"  & group == 1,]))
p1 <- plot(conf)
p2 <- plot(conf, nonZero = TRUE) # Only intervals without 0.
grid.arrange(p1,p2)

# Comparison repeated but based on ER matrices
gem <- GEM(proteins ~ MS * group, data = MS)
print(effs <- colnames(gem$symbolicDesign)) # Inspect factor names
confGEM <- confints(gem, factor=effs[3], levels=c("yes.1","no.1"))
p1g <- plot(confGEM)
p2g <- plot(confGEM, nonZero = TRUE) # Only intervals without 0.
grid.arrange(p1g,p2g)

# Shorter plot with labels
confShort <- conf[1:10,]
p1 <- plot(confShort, labels = TRUE)
p2 <- plot(confShort, labels = TRUE, nonZero = TRUE)
grid.arrange(p1,p2)
}
\seealso{
Analyses using \code{GEM}: \code{\link{elastic}}, \code{\link{pca}}, \code{\link{sca}}, \code{\link{neuralnet}}, \code{\link{pls}}.
}
