% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGEE.R, R/getME.R
\name{getGEE}
\alias{getGEE}
\alias{getME}
\title{Get information for a geelm/geeglm object}
\usage{
getGEE(object, name, ...)

getME(object, name, ...)
}
\arguments{
\item{object}{A geeglm model object as obtained from \code{geepack::geeglm()}
or a geelm object as obtained from \code{geeasy::geelm()}}

\item{name}{Name of the slot/component of the geelm/geeglm object that should be returned.
See list of possible names in details below.}

\item{...}{Any additional arguments passed on to other functions.}
}
\value{
The requested slot of the object.
}
\description{
Get information for a geelm/geeglm object
}
\details{
The allowed names are:

\code{coefficients} or \code{beta}: Coefficients from the mean
structure model (betas) on their original scales

\code{residuals}: Pearson residuals, in the order of the inputted
dataset (with NAs omitted).

\code{fitted.values}: Fitted values (response scale), in the order
of the inputted dataset (with NAs omitted).

\code{rank}: The rank of the model matrix, i.e. the number of
estimated mean structure coefficients.

\code{family}: A family object specifying which exponential family
was used for fitting the mean structure model, see
\code{\link{family}} for more information.

\code{linear.predictors}: The linear predictor on the original
scale.

\code{df.residuals}: Residual degrees of freedom.

\code{corstr}: Name of the correlation structured imposed on the
model. If the correlation structure requires further information,
it is stored in a suitably named attribute. For example, for
m-dependent correlation structures, the m scalar is available in an
attribute named \code{Mv}.

\code{std.err}: Method used to estimate the standard error of the
mean structure coefficients (betas).

\code{alpha}: The estimated parameter(s) for the variance
structure.

\code{gamma} or \code{dispersion}: The estimated dispersion
parameter.

\code{vbeta}: The estimated variance matrix of the mean structure
(beta) coefficients.

\code{beta.se}: The standard errors of the mean structure (beta)
coefficients.

\code{clusz} or \code{clustersizes}: Sizes of each of the clusters
in the data.

\code{nclusters}: The total number of clusters.
}
\section{Functions}{
\itemize{
\item \code{getME()}: 

}}
