% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evgram-plot.R
\name{plot.evgram}
\alias{plot.evgram}
\title{Plot \code{evgram} object}
\usage{
\method{plot}{evgram}(x, ..., split = FALSE, add_legend = TRUE, args_legend = list())
}
\arguments{
\item{x}{An \code{evgram} object produced by the \code{\link[gear]{evgram}} function.}

\item{...}{Additional arguments to pass the \code{\link[graphics]{plot}} function to change aspects of the plot.}

\item{split}{A logical value indicating whether, for a directional 
semivariogram, the directional semivariograms should be displayed 
in a single or split panels.  Default is FALSE, for a single panel.}

\item{add_legend}{A logical value indicating whether a 
legend should be included for a plot of directional
semivariograms when \code{split = FALSE}.}

\item{args_legend}{A list with arguments for 
\code{\link[graphics]{legend}}.}
}
\description{
Plots \code{evgram} object produced by  
\code{\link[gear]{evgram}} using the 
\code{\link[graphics]{plot}} function.
}
\details{
The arguments after \code{...} are only considered
if a directional semivariogram is provided, i.e., 
when \code{x$ndir != 1}. 

\code{split} will split directional semivariograms into
different plots automatically using 
\code{\link[autoimage]{autosize}}.

\code{add_legend} and \code{args_legend} are only used
for a directional semivariogram when \code{split = FALSE}
}
\examples{
data(co)
# omnidirectional example
v = evgram(Al ~ 1, co, ~ easting + northing)
plot(v)
plot(v, main = "semivariogram of Al")

# directional semivariograms overlaid
v2 = evgram(Al ~ 1, co, ~ easting + northing,
            angle = 22.5, ndir = 4)
plot(v2)
plot(v2, ylab = "semi-variance", pch = 2:5, type = "p")
plot(v2, lty = 2:5, type = "l", 
     args_legend = list(x = "bottomright",
                        legend = c("22.5", "67.5", "112.5", "157.5")))
# directional semivariograms split
plot(v2, split = TRUE)
plot(v2, split = TRUE, col = 2, pch = 3, type = "b",
     main = c("(a)", "(b)", "(c)", "(d)"))
}
\seealso{
\code{\link[lattice]{xyplot}}, \code{\link[gear]{evgram}}
}
\author{
Joshua French
}
