% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vgram.R
\name{plot.vgram}
\alias{plot.vgram}
\title{Plot vgram object}
\usage{
\method{plot}{vgram}(x, ..., split = FALSE)
}
\arguments{
\item{x}{A \code{vgram} object produced by the \code{vgram} function.}

\item{...}{Additional arguments to pass the \code{lattice::xyplot} function to change aspects of the plot.}

\item{split}{A logical value indicating whether, for a directional semivariogram, the directional semivariograms should be displayed in a single or split panels.  Default is FALSE, for a single panel.}
}
\description{
Plots object of class '\code{vgram}' produced by the \code{vgram} function.  The plot is based on the \code{lattice::xyplot} function.
}
\examples{
data(co)
v = vgram(Al ~ 1, co, ~ easting + northing)
plot(v)
v2 = vgram(Al ~ 1, co, ~ easting + northing, angle = 22.5, ndir = 4)
plot(v2)
# show how attributes can be changed using different arguments
# available in \\code{lattice::xyplot}.
plot(v2, col = 2:5)
plot(v2, col = 2:5, pch = 1:4)
plot(v2, col = 2:5, pch = 1:4, lty = 2:5, type = "b")
plot(v2, col = 2:5, pch = 1:4, lty = 2:5, type = "b", 
 key=list(text=list(levels(as.factor(v2$semi$angle))), 
 space='right', points=list(pch=1:4, col=2:5), 
 lines=list(col=2:5, lty = 2:5)))
plot(v2, split = TRUE)
}
\author{
Joshua French
}
\seealso{
\code{\link[lattice]{xyplot}}, \code{\link{vgram}}
}

