\name{apply.gdsn}
\alias{apply.gdsn}
\title{Apply functions over matrix margins}
\description{
	Returns a vector or list of values obtained by applying a function to margins of a matrix,
in a CoreArray Genomic Data Structure (GDS) file.
}

\usage{
apply.gdsn(node, margin=2, row.sel=NULL, col.sel=NULL, buf.size=1024, simplify=TRUE, FUN, ...)
}
\arguments{
	\item{node}{an object of class \code{\link[gdsfmt]{gdsn}}, a GDS node}
	\item{margin}{an integer giving the subscripts which the function will be applied
		over. E.g., for a matrix 1 indicates rows, 2 indicates columns}
	\item{row.sel}{a logical vector giving which rows will be used, or NULL for all rows}
	\item{col.sel}{a logical vector giving which columns will be used, or NULL for all columns}
	\item{buf.size}{the size of blocking buffer, the algorithm is optimized by blocking
		the computations to exploit the high-speed memory instead of disk. See details}
	\item{simplify}{if TRUE, the result will be simplified to a vector, matrix or higher
		dimensional array if possible}
	\item{FUN}{the function to be applied}
	\item{...}{optional arguments to \code{FUN}}
}
\details{
	The algorithm of applying is optimized by blocking the computations to exploit the
high-speed memory instead of disk. It loads \code{buf.size} of columns or rows each time,
and then call \code{FUN}. In general, it is better to choose a large value of \code{buf.size},
however, the value of \code{buf.size} should not make the internal buffer exceed the main
memory.
}
\value{
	A vector or list of values.
}

\references{\url{http://sourceforge.net/projects/corearray/}}
\author{Xiuwen Zheng \email{zhengx@u.washington.edu}}
\seealso{
	\code{\link[gdsfmt]{applylt.gdsn}},
	\code{\link[gdsfmt]{read.gdsn}}, \code{\link[gdsfmt]{readex.gdsn}},
	\code{\link[gdsfmt]{append.gdsn}}, \code{\link[gdsfmt]{write.gdsn}},
	\code{\link[gdsfmt]{add.gdsn}}
}

\examples{
# cteate the GDS file "test.gds"
(f <- createfn.gds("test.gds"))

(n <- add.gdsn(f, "matrix", val=matrix(as.character(1:(10*6)), nrow=10)))
read.gdsn(index.gdsn(f, "matrix"))

# Apply functions over rows of matrix
tmp <- apply.gdsn(n, margin=1, buf.size=2, FUN=function(x) print(x))
tmp <- apply.gdsn(n, margin=1,
	row.sel=rep(c(TRUE, FALSE), 5), col.sel=rep(c(TRUE, FALSE), 3),
	FUN=function(x) print(x))

# Apply functions over columns of matrix
tmp <- apply.gdsn(n, margin=2, FUN=function(x) print(x))
tmp <- apply.gdsn(n, margin=2,
	row.sel=rep(c(TRUE, FALSE), 5), col.sel=rep(c(TRUE, FALSE), 3),
	FUN=function(x) print(x))


closefn.gds(f)
}

\keyword{utilities}
