% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{inv_project}
\alias{inv_project}
\title{Inverse project geospatial x/y coordinates to longitude/latitude}
\usage{
inv_project(pts, srs, well_known_gcs = NULL)
}
\arguments{
\item{pts}{A data frame or numeric matrix containing geospatial point
coordinates, or point geometries as a list of WKB raw vectors or character
vector of WKT strings. If data frame or matrix, the number of columns must
be either two (x, y), three (x, y, z) or four (x, y, z, t).
May be also be given as a numeric vector for one point (xy, xyz, or xyzt).}

\item{srs}{Character string specifying the projected spatial reference
system for \code{pts}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{well_known_gcs}{Optional character string containing a supported
well known name of a geographic coordinate system (see Details for
supported values).}
}
\value{
Numeric matrix of longitude, latitude (potentially also with z,
or z and t columns).
}
\description{
\code{inv_project()} transforms geospatial x/y coordinates to
longitude/latitude in the same geographic coordinate system used by the
given projected spatial reference system. The output long/lat can
optionally be set to a specific geographic coordinate system by specifying
a well known name (see Details).
}
\details{
By default, the geographic coordinate system of the projection specified
by \code{srs} will be used. If a specific geographic coordinate system is
desired, then \code{well_known_gcs} can be set to one of the values below:
\tabular{rl}{
EPSG:n \tab where n is the code of a geographic coordinate system\cr
WGS84  \tab same as EPSG:4326\cr
WGS72  \tab same as EPSG:4322\cr
NAD83  \tab same as EPSG:4269\cr
NAD27  \tab same as EPSG:4267\cr
CRS84  \tab same as WGS84\cr
CRS72  \tab same as WGS72\cr
CRS27  \tab same as NAD27
}
The coordinates returned by \code{inv_project()}will always be in longitude,
latitude order (traditional GIS order) regardless of the axis order defined
for the GCS names above.
}
\note{
Input points that contain missing values (\code{NA}) will be assigned \code{NA} in
the output and a warning emitted. Input points that fail to transform
with the GDAL API call will also be assigned \code{NA} in the output with a
specific warning indicating that case.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
# id, x, y in NAD83 / UTM zone 12N
pts <- read.csv(pt_file)
print(pts)
inv_project(pts[,-1], "EPSG:26912")
}
\seealso{
\code{\link[=transform_xy]{transform_xy()}}
}
