% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{inspectDataset}
\alias{inspectDataset}
\title{Obtain information about a GDAL raster or vector dataset}
\usage{
inspectDataset(filename, ...)
}
\arguments{
\item{filename}{Character string containing the name of the file to access.
This may not refer to a physical file, but instead contain information for
the driver on how to access a dataset (e.g., connection string, URL, etc.)}

\item{...}{Additional arguments passed to \code{identifyDriver()}.}
}
\value{
A list with the following named elements:
\itemize{
\item \verb{$format}: character string, the format short name
\item \verb{$supports_raster}: logical, \code{TRUE} if the format supports raster data
\item \verb{$contains_raster}: logical, \code{TRUE} if this is a raster dataset or the
source contains raster subdatasets
\item \verb{$supports_subdatasets}: logical, \code{TRUE} if the format supports raster
subdatasets
\item \verb{$contains_subdatasets}: logical, \code{TRUE} if the source contains subdatasets
\item \verb{$subdataset_names}: character vector containing the subdataset names, or
empty vector if subdatasets are not supported or not present
\item \verb{$supports_vector}: logical, \code{TRUE} if the format supports vector data
\item \verb{$contains_vector}: logical, \code{TRUE} if the source contains one or more
vector layers
\item \verb{$layer_names}: character vector containing the vector layer names, or
empty vector if the format does not support vector or the source does not
contain any vector layers
}
}
\description{
\code{inspectDataset()} returns information about the format and content
of a dataset. The function first calls \code{identifyDriver()}, and then opens
the dataset as raster and/or vector to obtain information about its content.
The return value is a list with named elements.
}
\note{
Subdataset names are the character strings that can be used to
instantiate \code{GDALRaster} objects.
See https://gdal.org/en/stable/en/latest/user/raster_data_model.html#subdatasets-domain.
}
\examples{
src <- system.file("extdata/ynp_fires_1984_2022.gpkg", package="gdalraster")

inspectDataset(src)
}
\seealso{
\code{\link[=gdal_formats]{gdal_formats()}}, \code{\link[=identifyDriver]{identifyDriver()}}
}
