% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{json_cube}
\alias{json_cube}
\title{Read a data cube from a json description file}
\usage{
json_cube(json, path = NULL)
}
\arguments{
\item{json}{length-one character vector with a valid json data cube description}

\item{path}{source data cube proxy object}
}
\value{
data cube proxy object
}
\description{
Read a data cube from a json description file
}
\details{
Data cubes can be stored as JSON description files. These files do not store any data but the recipe
how a data cube is consructed, i.e., the chain (or graph) of processes involved. 

Since data cube objects (as returned from \code{\link{raster_cube}}) cannot be saved with normal R methods,
the combination of \code{\link{as_json}} and \code{\link{json_cube}} provides a cheap way to save data cube
objects across several R sessions, as in the examples.
}
\examples{
{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
cube = raster_cube(L8.col, v) 

# save
fname = tempfile()
writeLines(as_json(cube), fname)

# load
json_cube(path = fname)  
}

}
