% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_pixel.R
\name{apply_pixel}
\alias{apply_pixel}
\title{Apply a function over (multi-band) pixels}
\usage{
apply_pixel(x, ...)
}
\arguments{
\item{x}{input data}

\item{...}{additional arguments passed to method implementations}
}
\value{
return value and type depend on the class of x
}
\description{
This generic function applies a function on pixels of a data cube, an R array, or other classes if implemented.
}
\examples{

# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-06"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
              
L8.col = image_collection(file.path(tempdir(), "L8.db"))
apply_pixel(raster_cube(L8.col, v), "(B05-B04)/(B05+B04)", "NDVI") 



d <- c(4,16,128,128)
x <- array(rnorm(prod(d)), d)
y <- apply_pixel(x, function(v) {
  v[1] + v[2] + v[3] - v[4]
})

}
\seealso{
\code{\link{apply_pixel.cube}}

\code{\link{apply_pixel.array}}
}
