% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdaltindex.R
\name{gdaltindex}
\alias{gdaltindex}
\title{gdaltindex}
\usage{
gdaltindex(
  index_file,
  gdal_file,
  f,
  tileindex,
  write_absolute_path,
  skip_different_projection,
  t_srs,
  src_srs_name,
  src_srs_format,
  lyr_name,
  output_Vector = FALSE,
  ignore.full_scan = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{index_file}{Character. The name of the output file to create/append to. The default shapefile will be created if it doesn't already exist, otherwise it will append to the existing file.}

\item{gdal_file}{Character. The input GDAL raster files, can be multiple files separated by spaces. Wildcards my also be used. Stores the file locations in the same style as specified here, unless -write_absolute_path option is also used.}

\item{f}{Character. format. The OGR format of the output tile index file. Default is Esri Shapefile.}

\item{tileindex}{Character. field_name. The output field name to hold the file path/location to the indexed rasters. The default tile index field name is location.}

\item{write_absolute_path}{Logical. The absolute path to the raster files is stored in the tile index file. By default the raster filenames will be put in the file exactly as they are specified on the command line.}

\item{skip_different_projection}{Logical. Only files with same projection as files already inserted in the tileindex will be inserted (unless -t_srs is specified). Default does not check projection and accepts all inputs.}

\item{t_srs}{Character. target_srs. Geometries of input files will be transformed to the desired target coordinate reference system. Using this option generates files that are not compatible with MapServer < 6.4. Default creates simple rectangular polygons in the same coordinate reference system as the input rasters.}

\item{src_srs_name}{Character. field_name. The name of the field to store the SRS of each tile. This field name can be used as the value of the TILESRS keyword in MapServer >= 6.4.}

\item{src_srs_format}{Character. type. The format in which the SRS of each tile must be written. Types can be AUTO, WKT, EPSG, PROJ.}

\item{lyr_name}{Character. name. Layer name to create/append to in the output tile index file.}

\item{output_Vector}{Logical. Return output dst_filename as a Spatial* object.  Currently only works with f="ESRI Shapefile".}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\value{
NULL or if(output_Vector), a SpatialPolygonsDataFrame.
}
\description{
R wrapper for gdaltindex: Builds a shapefile as a raster tileindex
}
\details{
This is an R wrapper for the 'gdaltindex' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdaltindex format (\url{http://www.gdal.org/gdaltindex.html}), or,
in some cases, can use R vectors to achieve the same end.  

This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL that has the right drivers 
as specified with the "of" (output format) parameter.
 
The user can choose to (optionally) return a SpatialPolygonsDataFrame of the output file.
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install
# and that raster and rgdal are also installed.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(require(rgdal) && valid_install)
{
# Modified example from the original gdaltindex documentation:
src_folder <- system.file("external/", package="gdalUtils")
output_shapefile <- paste(tempfile(),".shp",sep="")
# Command-line gdalwarp call:
# gdaltindex doq_index.shp external/*.tif
gdaltindex(output_shapefile,list.files(path=src_folder,pattern=glob2rx("*.tif"),full.names=TRUE),
	output_Vector=TRUE,verbose=TRUE)
}
}
\references{
\url{http://www.gdal.org/gdaltindex.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
