\name{gdalinfo}
\alias{gdalinfo}
\title{gdalinfo}
\usage{
gdalinfo(datasetname, mm, stats, approx_stats, hist, nogcp, nomd, nrat, noct,
  nofl, checksum, proj4, mdd, sd, version, formats, format, optfile, config,
  debug, additional_commands, raw_output = TRUE, ignore.full_scan = TRUE,
  verbose = FALSE)
}
\arguments{
  \item{datasetname}{Character. A raster dataset name. It
  can be either file name.}

  \item{mm}{Logical. Force computation of the actual
  min/max values for each band in the dataset?}

  \item{stats}{Logical. Read and display image statistics.
  Force computation if no statistics are stored in an
  image.}

  \item{approx_stats}{Logical. Read and display image
  statistics. Force computation if no statistics are stored
  in an image. However, they may be computed based on
  overviews or a subset of all tiles. Useful if you are in
  a hurry and don't want precise stats.}

  \item{hist}{Logical. Report histogram information for all
  bands.}

  \item{nogcp}{Logical. Suppress ground control points list
  printing. It may be useful for datasets with huge amount
  of GCPs, such as L1B AVHRR or HDF4 MODIS which contain
  thousands of them.}

  \item{nomd}{Logical. Suppress metadata printing. Some
  datasets may contain a lot of metadata strings.}

  \item{nrat}{Logical. Suppress printing of raster
  attribute table.}

  \item{noct}{Logical. Suppress printing of color table.}

  \item{checksum}{Logical. Force computation of the
  checksum for each band in the dataset.}

  \item{mdd}{Character. Report metadata for the specified
  domain.}

  \item{nofl}{Logical. (GDAL >= 1.9.0) Only display the
  first file of the file list.}

  \item{sd}{Numeric. (GDAL >= 1.9.0) If the input dataset
  contains several subdatasets read and display a
  subdataset with specified number (starting from 1). This
  is an alternative of giving the full subdataset name.}

  \item{proj4}{Logical. (GDAL >= 1.9.0) Report a PROJ.4
  string corresponding to the file's coordinate system.}

  \item{version}{Logical. Report the version of GDAL and
  exit.}

  \item{formats}{Logical. List all raster formats supported
  by this GDAL build (read-only and read-write) and exit.
  The format support is indicated as follows: 'ro' is
  read-only driver; 'rw' is read or write (ie. supports
  CreateCopy); 'rw+' is read, write and update (ie.
  supports Create). A 'v' is appended for formats
  supporting virtual IO (/vsimem, /vsigzip, /vsizip, etc).
  A 's' is appended for formats supporting subdatasets.
  Note: The valid formats for the output of gdalwarp are
  formats that support the Create() method (marked as rw+),
  not just the CreateCopy() method.}

  \item{format}{Character. List detailed information about
  a single format driver. The format should be the short
  name reported in the --formats list, such as GTiff.}

  \item{optfile}{Character. Read the named file and
  substitute the contents into the commandline options
  list. Lines beginning with # will be ignored. Multi-word
  arguments may be kept together with double quotes.}

  \item{config}{Character. Sets the named configuration
  keyword to the given value, as opposed to setting them as
  environment variables. Some common configuration keywords
  are GDAL_CACHEMAX (memory used internally for caching in
  megabytes) and GDAL_DATA (path of the GDAL "data"
  directory). Individual drivers may be influenced by other
  configuration options.}

  \item{debug}{Character. Control what debugging messages
  are emitted. A value of ON will enable all debug
  messages. A value of OFF will disable all debug messages.
  Another value will select only debug messages containing
  that string in the debug prefix code.}

  \item{additional_commands}{Character. Additional commands
  to pass directly to gdalinfo.}

  \item{raw_output}{Logical. Dump the raw output of the
  gdalinfo (default=TRUE). If not, attempt to return a
  clean list (not all parameters will be retained, at
  present).}

  \item{ignore.full_scan}{Logical. If FALSE, perform a
  brute-force scan if other installs are not found.
  Default is TRUE.}

  \item{verbose}{Logical. Enable verbose execution? Default
  is FALSE.}
}
\value{
character (if raw_output=TRUE) or list (if
raw_output=FALSE).
}
\description{
R wrapper for gdalinfo
}
\details{
This is an R wrapper for the 'gdalinfo' function that is
part of the Geospatial Data Abstraction Library (GDAL).  It
follows the parameter naming conventions of the original
function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single
character string following, precisely, the gdalinfo format
(\url{http://www.gdal.org/gdalinfo.html}), or, in some
cases, can use R vectors to achieve the same end.

This function assumes the user has a working GDAL on their
system.  If the "gdalUtils_gdalPath" option has been set
(usually by gdal_setInstallation), the GDAL found in that
path will be used.  If nothing is found,
gdal_setInstallation will be executed to attempt to find a
working GDAL.

By default, this will return the gdalinfo as a character
vector, one line of the output per element.  The user can
choose raw_output=FALSE for a cleaner format (similar to
GDALinfo in the rgdal package), although not all parameters
are preserved.
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(valid_install)
{
src_dataset <- system.file("external/tahoe_highrez.tif", package="gdalUtils")
# Command-line gdalinfo call:
# gdalinfo tahoe_highrez.tif
gdalinfo(src_dataset,verbose=TRUE)
}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) and
Matteo Mattiuzzi (wrapper) and Frank Warmerdam (GDAL lead
developer).
}
\references{
\url{http://www.gdal.org/gdalinfo.html}
}

