% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_6800.R
\name{read_6800_txt}
\alias{read_6800_txt}
\title{Reads 6800 text files and creates a tibble with gas-exchange data.}
\usage{
read_6800_txt(filename)
}
\arguments{
\item{filename}{an text file containing 6800 gas-exchange data.}
}
\value{
A tibble with gas-exchange data in columns.
}
\description{
The text files stored by the 6800 contain measured and calculated values that
are read by this function and formatted in a large tibble for use with R.
Constants and metadata (such as calibration information) are also added as
columns. Note that no recalculation of the gas-exchange parameters is
performed, although it is possible to do that using \code{\link[=recalculate]{recalculate()}} after
importing the data.
}
\details{
Multiple files can be loaded by calling the function with \code{\link[=lapply]{lapply()}} or
\code{\link[purrr:map]{purrr::map()}} to merge multiple files. In this case, it is important
to ensure that the column names will match.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")
# import factory calibration for example data:
import_factory_cals(exampledir)

# read data
li6800 <- read_6800_xlsx(paste0(exampledir, "//lowo2.xlsx"))
li6800_txt <- read_6800_txt(paste0(exampledir, "//lowo2"))

# compare all except equations. Note txt file reports some NAs as zero:
columns_to_check <- names(li6800)[!names(li6800) \%in\%
                                   c("gasanalyzer.Equations")]
all.equal(li6800[columns_to_check],
          li6800_txt[columns_to_check],
          tol = 0.01)

}
\seealso{
\code{\link[=recalculate]{recalculate()}}
}
