% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{permutate}
\alias{permutate}
\title{Expand a data frame with all possible combinations of the values in a column.}
\usage{
permutate(df, ...)
}
\arguments{
\item{df}{a dataframe or tibble}

\item{...}{a name-value pair. The name gives the name of the column in the
input that is to be changed. The value is a vector specifying all values
that are desired in the output. For every value in this vector, all other
rows are duplicated.}
}
\value{
a data frame containing all possible combinations of the input df
and the vector specified in ...

Note that the units and classes of the columns in the input data frame are
applied to the replacement values. Unexpected behavior may occur when
providing incompatible classes or units.
}
\description{
For sensitivity analyses, it is useful to permutate the values in a single
column, whilst keeping all other values constant. After creating such a
permutation, \code{\link[=recalculate]{recalculate()}} should be used to analyze the effect of the
change in the column of interest. If the effect of changes in multiple
columns is to be analyzed, this function can be called in series.
}
\examples{
example <- system.file("extdata//6400-testfile", package = "gasanalyzer")

# read data:
li6400 <- read_6400_txt(example)

# expand the data frame for a range of leaf areas, and recalculate the data:
li6400 <- permutate(li6400, Const.S = seq(1, 8)) |>
  recalculate(create_equations(c("default", "li6400")))

if (interactive()) {
  require(units)
  require(graphics)

  # observe that changing the leaf area enclosed in the chamber would have a
  # nonlinear effect on the rate of photosynthesis:
  aggregate(list(A = li6400$GasEx.A), list(Area = (li6400$Const.S)), mean) |>
    plot()
}
}
