% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{forecast.garma_model}
\alias{forecast.garma_model}
\title{The forecast function predicts future values of a "garma_model" object, and is exactly the same as the "predict" function with slightly different parameter values.}
\usage{
\method{forecast}{garma_model}(mdl, h = 1)
}
\arguments{
\item{mdl}{(garma_model) The garma_model from which to forecast the values.}

\item{h}{(int) The number of time periods to predict ahead. Default: 1}
}
\value{
- a "ts" object containing the requested forecasts.
}
\description{
The forecast function predicts future values of a "garma_model" object, and is exactly the same as the "predict" function with slightly different parameter values.
}
\examples{
library(forecast)

data(AirPassengers)
ap  <- as.numeric(diff(AirPassengers,12))
mdl <- garma(ap,order=c(9,1,0),k=0,method='CSS',include.mean=FALSE)
forecast(mdl, h=12)
}
