% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl2dplotly.R
\name{qtl2dplotly}
\alias{qtl2dplotly}
\title{2D QTL plotly}
\usage{
qtl2dplotly(
  d,
  chrlen = gap::hg19,
  qtl.id = "SNPid:",
  qtl.prefix = "QTL:",
  qtl.gene = "Gene:",
  target.type = "Protein",
  TSS = FALSE,
  xlab = "QTL position",
  ylab = "Gene position",
  ...
)
}
\arguments{
\item{d}{Data in qtl2dplot() format.}

\item{chrlen}{Lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{qtl.id}{QTL id.}

\item{qtl.prefix}{QTL prefix.}

\item{qtl.gene}{QTL gene.}

\item{target.type}{Type of target, e.g., protein.}

\item{TSS}{to use TSS when TRUE.}

\item{xlab}{X-axis title.}

\item{ylab}{Y-axis title.}

\item{...}{Additional arguments, e.g., target, log10p, to qtl2dplot.}
}
\value{
A plotly figure.
}
\description{
2D QTL plotly
}
\examples{
\dontrun{
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE)
r <- qtl2dplotly(d)
htmlwidgets::saveWidget(r,file=file.path(INF,"INF1.qtl2dplotly.html"))
r
}
}
