### The container code in Ext is very similar.
## All use Ext.Panel with some different configuration options
## this code tries to take advantage of that  by introducing some sub"traits".
## the tricky thing is the call up to ExtCfgOptions from the inherited trait.
## just calling with .super didn't work

EXTPanel <- EXTContainer$new()
EXTPanel$ExtConstructor <- "Ext.Panel"



EXTGroup <- EXTPanel$new(children=list())
EXTGroup$ExtCfgOptions <-  function(.) {
  out <- list(
              border = FALSE,
              hideBorders=TRUE,          # key to getting rid of blud
              collapsed=!.$..visible
              
              )
  if(exists("..horizontal",envir=., inherits=FALSE)) {
    if(.$..horizontal) {
      orientation <- "column"
      out[['layout']] <- orientation
      if(exists("..use.scrollwindow", envir=., inherits=FALSE))
        out[['autoScroll']] <- .$..use.scrollwindow
    }
    ## no "row" layout, so we use the default.
  }
  ## size
##  out[['autoWidth']] <- TRUE
  if(exists("..width", envir = ., inherits =FALSE))
    out[["width"]] <- .$..width
  if(exists("..height", envir = ., inherits =FALSE))
    out[["height"]] <- .$..height
  spacing <- 10
  if(exists("..spacing", envir=., inherits=FALSE)) spacing <- .$..spacing
##  out[['spacing']] <- spacing
#  out[["bodyStyle"]] = String('{') + 'padding:"' + spacing + 'px"}'
    out[["bodyStyle"]] = list('padding' = String('"') + spacing + 'px"'  )
  return(out)
}
## even group can be made visible/hidden
EXTGroup$setVisibleJS <- function(.) {
  if(exists("..setVisibleJS", envir=., inherits=FALSE))
    .$..setVisibleJS()
  if(.$..visible)
    .$callExtMethod("expand","true")
  else
    .$callExtMethod("collapse","true")
}

## these are not defined
EXTGroup$addSpring <- function(.) {invisible("")}
EXTGroup$addSpace <- function(., value, horizontal=TRUE, ...) {}

ggroup <- function(horizontal=TRUE, spacing=5, use.scrollwindow = FALSE,
                    container,...) {
   ## a group
  cont <- EXTGroup$new(toplevel = container$toplevel,
                     ..horizontal = horizontal,
                     ..spacing = spacing,
                     ..use.scrollwindow = use.scrollwindow
                     )
  cont$..visible <- TRUE
  
  theArgs <- list(...)
  if(!is.null(theArgs$width)) cont$..width <- theArgs$width
  if(!is.null(theArgs$height)) cont$..height <- theArgs$height

  class(cont) <- c("gGroup",class(cont))
   container$add(cont,...)
   invisible(cont)
 }

EXTFrame <- EXTGroup$new(children=list())
EXTFrame$ExtCfgOptions <- function(.) {
  out <- EXTGroup[['ExtCfgOptions']](.)
  out[['title']] <- escapeHTML(svalue(.))
  return(out)
}
EXTFrame$setValueJSMethod = "setTitle"
     
gframe <- function(text = "", pos = 0, horizontal=TRUE, container=NULL,...) {

  cont <- EXTFrame$new(toplevel = container$toplevel,
                    ..horizontal = horizontal)
                    
  cont$..visible <- TRUE

  theArgs <- list(...)
  if(!is.null(theArgs$width)) cont$..width <- theArgs$width
  if(!is.null(theArgs$height)) cont$..height <- theArgs$height

  
  class(cont) <- c("gFrame",class(cont))
  cont$setValue(value=text)
  cont$..pos <- pos

  cont$..ExtCfgOptions <- function(.)
    list(border=TRUE)
  
  container$add(cont,...)  
  invisible(cont)
}


EXTExpandGroup <- EXTFrame$new(children=list())
EXTExpandGroup$ExtCfgOptions <- function(.) {
  out <- .super$ExtCfgOptions(.)
  out[['collapsible']] <- TRUE
  out[['titleCollapse']] <- TRUE
  return(out)
}

gexpandgroup <- function(text = "", horizontal = TRUE,
                         handler = NULL, action=NULL,
                         container=NULL, ...) {

  cont <- EXTExpandGroup$new(toplevel=container$toplevel,
                            ..horizontal=horizontal)
  cont$..visible <- TRUE
  
  theArgs <- list(...)
  if(!is.null(theArgs$width)) cont$..width <- theArgs$width
  if(!is.null(theArgs$height)) cont$..height <- theArgs$height

  class(cont) <- c("gExpandgroup",class(cont))
  cont$setValue(value=text)

  cont$..ExtCfgOptions <- function(.) {
    out <- list(border=TRUE
                )
  }

  if(!is.null(handler))
    addHandlerClicked(cont, handler = handler, action=action)

  container$add(cont,...)    
  invisible(cont)
}
  
