

#' Overview - the gRain package for graphical independence networks
#' 
#' Probability propagation in graphical independence networks, (also known as
#' probabilistic expert or Bayesian networks).
#' 
#' This package implements graphical independence networks.
#' 
#' The main function for building networks is \code{\link{grain}}.
#' 
#' The function \code{\link{querygrain}} is used for querying independence
#' networks.
#' 
#' Functions \code{\link{simulate.grain}} and \code{\link{predict.grain}} are
#' available.
#' 
#' There is a small vignette which illustrates the use of gRain.
#' 
#' @name gRain-package
#' @aliases gRain-package gRain
#' @docType package
#' @author Søren Højsgaard \email{sorenh@@math.aau.dk}
#' 
#' Maintainer: Søren Højsgaard \email{sorenh@@math.aau.dk}
#' @references Søren Højsgaard (2012). Graphical Independence Networks
#' with the gRain Package for R. Journal of Statistical Software, 46(10), 1-26.
#' \url{http://www.jstatsoft.org/v46/i10/}.
#' @keywords package







