% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{gMCP.extended}
\alias{gMCP.extended}
\title{Graph based Multiple Comparison Procedures}
\usage{
gMCP.extended(graph, pvalues, test, alpha = 0.05, eps = 10^(-3),
  upscale = FALSE, verbose = FALSE, adjPValues = TRUE, ...)
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}}.}

\item{pvalues}{A numeric vector specifying the p-values for the graph based
MCP. Note the assumptions in the description of the selected test (if there are any -
for example \code{test=bonferroni.test} has no further assumptions, but
\code{test=parametric.test} assumes p-values from a multivariate normal distribution).}

\item{test}{A weighted test function.

The package gMCP provides the following weighted test functions:
\describe{
  \item{bonferroni.test}{Bonferroni test - see \code{?bonferroni.test} for details.}
  \item{parametric.test}{Parametric test - see \code{?parametric.test} for details.}
  \item{simes.test}{Simes test - see \code{?simes.test} for details.}
  \item{bonferroni.trimmed.simes.test}{Trimmed Simes test for intersections of two hypotheses and otherwise Bonferroni - see \code{?bonferroni.trimmed.simes.test} for details.}
  \item{simes.on.subsets.test}{Simes test for intersections of hypotheses from certain sets and otherwise Bonferroni - see \code{?simes.on.subsets.test} for details.}
}

To provide your own test function see \code{?weighted.test.function}.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate.}

\item{eps}{A numeric scalar specifying a value for epsilon edges.}

\item{upscale}{Logical. If \code{upscale=FALSE} then for each intersection 
of hypotheses (i.e. each subgraph) a weighted test is performed at the 
possibly reduced level alpha of sum(w)*alpha, 
where sum(w) is the sum of all node weights in this subset.
If \code{upscale=TRUE} all weights are upscaled, so that sum(w)=1.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated
during sequentially rejection steps.}

\item{adjPValues}{Logical scalar. If \code{FALSE} no adjusted p-values will
be calculated. Especially for the weighted Simes test this will result in
significantly less calculations in most cases.}

\item{...}{Test specific arguments can be given here.}
}
\value{
An object of class \code{gMCPResult}, more specifically a list with
elements
\describe{
\item{\code{graphs}}{list of graphs}
\item{\code{pvalues}}{p-values}
\item{\code{rejected}}{logical whether hyptheses could be rejected}
\item{\code{adjPValues}}{adjusted p-values}
}
}
\description{
Performs a graph based multiple test procedure for a given graph and unadjusted p-values.
}
\examples{


g <- BonferroniHolm(5)
gMCP(g, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7))
# Simple Bonferroni with empty graph:
g2 <- matrix2graph(matrix(0, nrow=5, ncol=5))
gMCP(g2, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7))
# With 'upscale=TRUE' equal to BonferroniHolm:
gMCP(g2, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7), upscale=TRUE)

# Entangled graphs:
g3 <- Entangled2Maurer2012()
gMCP(g3, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7), correlation=diag(5))

}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch: A
graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604.
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}

Bretz F., Posch M., Glimm E., Klinglmueller F., Maurer W., Rohmeyer K.
(2011): Graphical approaches for multiple endpoint problems using weighted
Bonferroni, Simes or parametric tests. Biometrical Journal 53 (6), pages 894-913, Wiley.
\url{http://onlinelibrary.wiley.com/doi/10.1002/bimj.201000239/full}

Strassburger K., Bretz F.: Compatible simultaneous lower confidence bounds
for the Holm procedure and other Bonferroni based closed tests. Statistics
in Medicine 2008; 27:4914-4927.

Hommel G., Bretz F., Maurer W.: Powerful short-cuts for multiple testing
procedures with special reference to gatekeeping strategies. Statistics in
Medicine 2007; 26:4063-4073.

Guilbaud O.: Simultaneous confidence regions corresponding to Holm's
stepdown procedure and other closed-testing procedures. Biometrical Journal
2008; 50:678-692.
}
\seealso{
\code{\link{graphMCP}} \code{\link[multcomp:contrMat]{graphNEL}}
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{htest}
