/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeWeight {
    protected String weightStr = null;
    protected Double weight = null;
    static DecimalFormat format = new DecimalFormat("#.###");
    static DecimalFormat formatSmall = new DecimalFormat("#.###E0");

    public EdgeWeight(String weightStr) {
        this.weightStr = weightStr = weightStr.replace('e', '\u03b5');
    }

    public EdgeWeight(double weight) {
        this.weight = weight;
        this.weightStr = !Configuration.getInstance().getGeneralConfig().showFractions() ? format.format(weight) : RControl.getFraction(weight, true);
    }

    public String toString() {
        return this.weightStr;
    }

    public double getWeight(Hashtable<String, Double> ht) {
        String replaceStr = this.weightStr;
        if (this.weight != null) {
            return this.weight;
        }
        Enumeration<String> keys = ht.keys();
        while (keys.hasMoreElements()) {
            String s = keys.nextElement();
            replaceStr = replaceStr.replaceAll(s, "" + ht.get(s));
        }
        this.weight = RControl.getR().eval(replaceStr).asRNumeric().getData()[0];
        return this.weight;
    }

    public List<String> getVariables() {
        Vector<String> variables = new Vector<String>();
        for (int i = 0; i < 26; ++i) {
            char l = (char)(97 + i);
            if (this.weightStr.lastIndexOf(l) == -1) continue;
            variables.add("" + l);
        }
        if (this.weightStr.lastIndexOf("\u03b5") != -1) {
            variables.add("\u03b5");
        }
        return variables;
    }

    public String getLaTeXStr() {
        if (this.weight != null) {
            return RControl.getR().eval("gMCP:::getLaTeXFraction(" + this.weight + ")").asRChar().getData()[0];
        }
        return this.weightStr.replace("\u03b5", "$\\epsilon$");
    }
}

