/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.GeneralConfig;
import org.mutoss.config.JavaConfig;
import org.mutoss.config.PlotConfig;

public class Configuration {
    protected static Log logger = LogFactory.getLog(Configuration.class);
    protected Preferences prefs = Preferences.userRoot();
    protected static Configuration instance = null;
    private String projectName;
    private final String keyPrefix = this.projectName + ".";
    public static final String NOTFOUND = "___NOT_FOUND___";
    public static final String TOXICOLOGY = "toxicology";
    public static final String DOSERESPONSE = "doseresponse";
    public static final String LOCALINSTALL = "local-install";
    public static final String UNIFIEDCLIENT = "unified-client";

    protected Configuration() {
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public void setClassProperty(Class c, String key, String value) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        this.setProperty(cn + "." + key, value);
    }

    public String getClassProperty(Class c, String key) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        return this.getProperty(cn + "." + key, NOTFOUND);
    }

    protected String getProperty(String prop, String def) {
        return this.prefs.get(this.keyPrefix + prop, def);
    }

    protected String getProperty(String prop) {
        String s = this.getProperty(prop, NOTFOUND);
        if (s.equals(NOTFOUND)) {
            throw new RuntimeException("Property required but not set: " + prop);
        }
        return s;
    }

    public void setProperty(String key, String val) {
        this.prefs.put(this.keyPrefix + key, val);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public GeneralConfig getGeneralConfig() {
        return new GeneralConfig(this);
    }

    public PlotConfig getPlotConfig() {
        return new PlotConfig(this);
    }

    public JavaConfig getJavaConfig() {
        return new JavaConfig(this);
    }

    public String getConfigurationForDebugPurposes() {
        String s = "";
        s = s + this.keyPrefix + "\n";
        try {
            for (String key : this.prefs.keys()) {
                if (!key.startsWith(this.keyPrefix)) continue;
                String val = this.prefs.get(key, "__NOT FOUND__");
                key = key.substring(this.keyPrefix.length());
                s = s + key + " : " + val + "\n";
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return s;
    }
}

