% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{edge_filter_lens}
\alias{edge_filter_lens}
\title{Configure Edge Filter Lens Plugin}
\usage{
edge_filter_lens(
  key = "edge-filter-lens",
  trigger = c("pointermove", "click", "drag"),
  r = 60,
  maxR = NULL,
  minR = 0,
  scaleRBy = "wheel",
  nodeType = c("both", "source", "target", "either"),
  filter = NULL,
  style = NULL,
  nodeStyle = list(label = FALSE),
  edgeStyle = list(label = TRUE),
  preventDefault = TRUE,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{trigger}{Method to move the lens: "pointermove", "click", or "drag" (string, default: "pointermove").}

\item{r}{Radius of the lens (number, default: 60).}

\item{maxR}{Maximum radius of the lens (number, default: NULL - half of the smaller canvas dimension).}

\item{minR}{Minimum radius of the lens (number, default: 0).}

\item{scaleRBy}{Method to scale the lens radius (string, default: "wheel").}

\item{nodeType}{Edge display condition: "both", "source", "target", or "either" (string, default: "both").}

\item{filter}{Filter out elements that are never displayed in the lens (JS function, default: NULL).}

\item{style}{Style of the lens (list, default: NULL).}

\item{nodeStyle}{Style of nodes in the lens (list or JS function, default: list(label = FALSE)).}

\item{edgeStyle}{Style of edges in the lens (list or JS function, default: list(label = TRUE)).}

\item{preventDefault}{Whether to prevent default events (boolean, default: TRUE).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/edge-filter-lens}.}
}
\value{
A list with the configuration settings for the edge-filter-lens plugin.
}
\description{
Creates a configuration object for the edge-filter-lens plugin in G6.
This plugin creates a lens that filters and displays edges within a specific area.
}
\examples{
# Basic configuration
config <- edge_filter_lens()

# Custom configuration
config <- edge_filter_lens(
  key = "my-edge-lens",
  trigger = "drag",
  r = 100,
  nodeType = "either",
  style = list(
    fill = "rgba(200, 200, 200, 0.3)",
    stroke = "#999",
    lineWidth = 2
  ),
  filter = JS("(id, type) => {
    // Only display edges connected to specific nodes
    if (type === 'edge') {
      const edge = graph.getEdgeData(id);
      return edge.source === 'node1' || edge.target === 'node1';
    }
    return true;
  }")
)
}
