% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_parameters.R
\name{screen_control}
\alias{screen_control}
\title{Set Parameters for Screening Step of
Fuzzy Forests}
\usage{
screen_control(drop_fraction = 0.25, keep_fraction = 0.05,
  mtry_factor = 1, min_ntree = 5000, ntree_factor = 10)
}
\arguments{
\item{drop_fraction}{A number between 0 and 1.  Percentage of features
dropped at each iteration.}

\item{keep_fraction}{A number between 0 and 1. Proportion of features
from each module that are retained from screening step.}

\item{mtry_factor}{In the case of regression, \code{mtry} is set to
\code{ceiling}(\eqn{\sqrt(p)}*\code{mtry_factor}).
In the case of classification, \code{mtry} is set to
\code{ceiling}((p/3)*\code{mtry_factor}).  If either
of these numbers is greater than p, \code{mtry} is
set to p.}

\item{min_ntree}{Minimum number of trees grown in each random forest.}

\item{ntree_factor}{A number greater than 1.  \code{ntree} for each
random forest is \code{ntree_factor} times the number
of features.  For each random forest, \code{ntree}
is set to \code{max}(\code{min_ntree},
\code{ntree_factor}*p).}
}
\value{
An object of type screen_control.
}
\description{
Creates \code{screen_control} object for
controlling how feature selection
will be carried out on each module.
}
\note{
This work was partially funded by NSF IIS 1251151 and AMFAR 8721SC.
}
\examples{
drop_fraction <- .25
keep_fraction <- .1
mtry_factor <- 1
min_ntree <- 5000
ntree_factor <- 5
screen_params <- screen_control(drop_fraction=drop_fraction,
                                keep_fraction=keep_fraction,
                                mtry_factor=mtry_factor,
                                min_ntree=min_ntree,
                                ntree_factor=ntree_factor)
}
\references{
Daniel Conn, Tuck Ngun, Christina M. Ramirez (2015). Fuzzy Forests: a New
WGCNA Based Random Forest Algorithm for Correlated, High-Dimensional Data,
Journal of Statistical Software, Manuscript in progress.
}

