% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{processEnsemble}
\alias{processEnsemble}
\title{Extract projections from ensemble member}
\usage{
processEnsemble(ensemble, modelName, global, custom, type)
}
\arguments{
\item{ensemble}{List with parsed information about the directory structure for
a specific ensemble member from the user-specified projections directory.
This list is a subset of the list generated by
\code{\link{acquireDirectoryStructure}}.}

\item{modelName}{Character string of climate model name (e.g., "bcc1"). This
name is generated from the subdirectory name for the climate model within
\code{dataFolder}.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}

\item{type}{A character vector giving the type of boundaries that are being
checked. Possible values are "threshold", "projections", and "reference".}
}
\value{
A list object with processed projections, as well as various other
   elements needed for further processing to identify heat waves.
}
\description{
This function extracts the desired climate data from a single ensemble
member, from one of the two experiment subdirectories.
}
\note{
This function calls another function that uses Euclidean distance for
   the distance between each city given in the
   \code{citycsv} file and the nearest grid point for the climate model
   for the specified ensemble member.
}

