% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflate_all.R
\name{inflate_all}
\alias{inflate_all}
\alias{inflate_all_no_check}
\title{Inflate all your flat files}
\usage{
inflate_all(
  pkg = ".",
  document = TRUE,
  check = TRUE,
  open_vignette = FALSE,
  overwrite = TRUE,
  clean = TRUE,
  stylers,
  ...
)

inflate_all_no_check(
  pkg = ".",
  document = TRUE,
  open_vignette = FALSE,
  overwrite = TRUE,
  clean = TRUE,
  stylers,
  ...
)
}
\arguments{
\item{pkg}{Path to package}

\item{document}{Logical. Whether to document your package using \code{\link[attachment:att_amend_desc]{att_amend_desc}}}

\item{check}{Logical. Whether to check package after Rmd inflating}

\item{open_vignette}{Logical. Whether to open vignette file at the end of the process}

\item{overwrite}{Logical (TRUE, FALSE) or character ("ask", "yes", "no).
Whether to overwrite vignette and functions if already exists.}

\item{clean}{Logical. Whether to help detect unregistered files.}

\item{stylers}{Function to be run at the end of the process, like \code{styler::style_pkg} or \code{lintr::lint_package} or a lambda function combining functions like: \code{function() {styler::style_pkg(); lintr::lint_package()}}. For a unique function, use the format without parenthesis \verb{()} at the end of the command.}

\item{...}{Arguments passed to \code{devtools::check()}.
For example, you can do \code{inflate(check = TRUE, quiet = TRUE)}, where \code{quiet} is
passed to \code{devtools::check()}.}
}
\value{
side effect. Inflates all your flat files that can be inflated.
}
\description{
Inflate all the flat files stored in "dev/" and starting with "flat_"
}
\details{
This requires to \code{\link[=inflate]{inflate()}} all flat files individually at least once, so that their specific inflate configurations are stored.

This also requires to register all R, tests and vignettes files of your package, even if not created with an inflate. Run \code{\link[=inflate_all]{inflate_all()}} once and read the messages. The first time, you will probably need to run \code{\link[=register_all_to_config]{register_all_to_config()}} if your package is not new.

For more information, read the \code{vignette("inflate-all-your-flat-files", package = "fusen")}
}
\examples{
\dontrun{
# Usually, in the current package run inflate_all() directly
# These functions change the current user workspace
inflate_all()
# Or inflate_all_no_check() to prevent checks to run
inflate_all_no_check()
# Or inflate with the styler you want
inflate_all(stylers = styler::style_pkg)
}

# You can also inflate_all flats of another package as follows
# Example with a dummy package with a flat file
dummypackage <- tempfile("inflateall.otherpkg")
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
flat_files <- add_minimal_package(
  pkg = dummypackage,
  overwrite = TRUE,
  open = FALSE
)
flat_file <- flat_files[grep("flat", basename(flat_files))]
# Inflate the flat file once
usethis::with_project(dummypackage, {
  # if you are starting from a brand new package, inflate_all() will crash
  # it's because of the absence of a fusen config file
  #
  # inflate_all() # will crash

  # Add licence
  usethis::use_mit_license("John Doe")

  # you need to inflate manually your flat file first
  inflate(
    pkg = dummypackage,
    flat_file = flat_file,
    vignette_name = "Get started",
    check = FALSE,
    open_vignette = FALSE,
    document = TRUE,
    overwrite = "yes"
  )

  # your config file has been created
  config_yml_ref <-
    yaml::read_yaml(getOption("fusen.config_file", default = "dev/config_fusen.yaml"))
})

# Next time, you can run inflate_all() directly
usethis::with_project(dummypackage, {
  # now you can run inflate_all()
  inflate_all(check = FALSE, document = TRUE)
})

# Clean the temporary directory
unlink(dummypackage, recursive = TRUE)
}
\seealso{
\code{\link[=inflate]{inflate()}} for the options of a single file inflate,
\code{\link[=check_not_registered_files]{check_not_registered_files()}} for the list of files not already associated with a flat file in the config file,
\code{\link[=register_all_to_config]{register_all_to_config()}} for automatically registering all files already present in the project before the first \code{inflate_all()}
}
