% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_functions.R
\name{fsi_add_cs}
\alias{fsi_add_cs}
\title{Adding the consequent to an FSI model}
\usage{
fsi_add_cs(fsi, lvar, lvals, mfs, bounds)
}
\arguments{
\item{fsi}{The FSI model instantiated with the \code{fsi_create} function.}

\item{lvar}{A character value that represents a linguistic variable of the consequent.}

\item{lvals}{A character vector that represents linguistic values of the linguistic variable of the consequent.}

\item{mfs}{A vector of functions created by the \code{genmf} of the FuzzyR package.}

\item{bounds}{A numeric vector that represents the lower and upper bounds of the consequent domain.}
}
\value{
An FSI model populated with a consequent.
}
\description{
This function adds the consequent to a fuzzy spatial inference (FSI) model. It consists of a set of membership functions labeled with linguistic values.
}
\details{
Each linguistic value defined at the \code{lvals} parameter has a membership function defined at the \code{mfs} parameter.
\code{lvals} is a character vector containing the names of linguistic values and \code{mfs} is vector containing its corresponding membership functions.
Thus, the vectors defined for these two parameters must have the same length.
For instance, the first value of \code{lvals} is the linguistic value for the first membership function in \code{mfs}.
In \code{bounds}, the lower and upper values correspond to the first and second parameter, respectively.
}
\examples{

library(FuzzyR)

# Create the fsi_model:
fsi <- fsi_create("To visit or not to visit, that is the question", 
                   default_conseq = genmf("trimf", c(10, 30, 60)))

# Create the vector with the linguistic values of the linguistic variable "visiting experience":
lvals_visiting_exp <- c("awful", "average", "great")

# Define the membership function for each linguistic value:
awful_mf <- genmf("trimf", c(0, 0, 20))
average_mf <- genmf("trimf", c(10, 30, 60))
great_mf <- genmf("trapmf", c(40, 80, 100, 100))

# Add the consequent to the FSI model:
fsi <- fsi_add_cs(fsi, "visiting experience", lvals_visiting_exp,
                  c(awful_mf, average_mf, great_mf), c(0, 100))

}
