% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_smooth.R, R/fslhd.R
\name{fsl_smooth}
\alias{fsl_smooth}
\alias{fslsmooth}
\title{Gaussian smooth image using FSL}
\usage{
fsl_smooth(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fslsmooth(file, sigma = 10, mask = NULL, smooth_mask = TRUE,
  smoothed_mask = NULL, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{...}{additional arguments passed to \code{\link{readnii}}.}

\item{outfile}{(character) resultant smoothed image name (optional)
if not give, will be the stub of the filename then _sigma}

\item{retimg}{(logical) return image of class nifti}

\item{file}{(character or nifti) image to be smoothed}

\item{sigma}{(numeric) sigma (in mm) of Gaussian kernel for smoothing}

\item{mask}{(character) optional mask given for image}

\item{smooth_mask}{(logical) Smooth mask?  If TRUE, the masked image 
will be divided by the smoothed mask.}

\item{smoothed_mask}{(character or nifti) If specified and 
\code{smooth_mask = TRUE}, then will use this as the smoothed mask for 
division.}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{verbose}{(logical) print out command before running}
}
\value{
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslmaths -s} to smooth an image and either
saves the image or returns an object of class nifti
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
\examples{
if (have.fsl()){
system.time({
dims = c(50, 50, 20)
x = array(rnorm(prod(dims)), dim = dims)
img = nifti(x, dim= dims, 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
s.img = fslsmooth(img, retimg=TRUE)
})
}
}
