% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4dash_font}
\alias{bs4dash_font}
\title{bs4Dash fonts parameters}
\usage{
bs4dash_font(
  size_base = NULL,
  size_lg = NULL,
  size_sm = NULL,
  size_xs = NULL,
  size_xl = NULL,
  weight_light = NULL,
  weight_normal = NULL,
  weight_bold = NULL,
  family_sans_serif = NULL,
  family_monospace = NULL,
  family_base = NULL
)
}
\arguments{
\item{size_base}{Base size, this size is used to calculate other size. Must in \code{rem} unit.}

\item{size_lg}{Large size.}

\item{size_sm}{Small size.}

\item{size_xs}{Extra small size.}

\item{size_xl}{Extra large size.}

\item{weight_light}{Light font weight.}

\item{weight_normal}{Normal font weight.}

\item{weight_bold}{Bold font weight.}

\item{family_sans_serif}{Sans serif font family.}

\item{family_monospace}{Monospace font family.}

\item{family_base}{Base font family.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
bs4Dash fonts parameters
}
\examples{

# Change font size used in bs4Dash
bs4dash_font(
  size_base = "1.5rem",
  weight_bold = 900
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash Custom Colors",
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(
      title = "bs4Dash Custom Colors",
      skin = "light",
      bs4SidebarMenu(
        bs4SidebarMenuItem(
          tabName = "tab1",
          text = "UI components"
        )
      )
    ),
    body = bs4DashBody(

      use_theme(create_theme(
        bs4dash_font(
          size_base = "1.5rem",
          weight_bold = 900
        )
      )),

      bs4TabItems(
        bs4TabItem(
          tabName = "tab1",
          tags$div(
            tags$p(
              paste(letters, collapse = "")
            ),
            tags$p(
              style = "font-weight: bold;",
              paste(letters, collapse = "")
            ),
            tags$p(
              style = "font-style: italic;",
              paste(letters, collapse = "")
            )
          ),
          tags$h1("First level title"),
          tags$h2("Second level title"),
          tags$h3("Third level title"),
          tags$h4("Fourth level title"),
          tags$h5("Fifth level title"),
          tags$h6("Sixth level title")
        )
      )
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}
}
