% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FSpacePartition.Method.R
\name{WM}
\alias{WM}
\title{WM model building}
\usage{
WM(data.train, num.labels, type.mf = "GAUSSIAN", type.tnorm = "PRODUCT",
  type.implication.func = "ZADEH", classification = FALSE,
  range.data = NULL)
}
\arguments{
\item{data.train}{a matrix (\eqn{m \times n}) of normalized data for the training process, where \eqn{m} is the number of instances and
\eqn{n} is the number of variables; the last column is the output variable.
Note the data must be normalized between 0 and 1.}

\item{num.labels}{a matrix (\eqn{1 \times n}), whose elements represent the number of labels (linguistic terms);
\eqn{n} is the number of variables.}

\item{type.mf}{the type of the membership function. See \code{\link{frbs.learn}}.}

\item{type.tnorm}{a value which represents the type of t-norm. See \code{\link{inference}}.}

\item{type.implication.func}{a value representing type of implication function. Let us consider a rule, \eqn{a \to b},
\itemize{
\item \code{DIENES_RESHER} means \eqn{(b > 1 - a? b : 1 - a)}.
\item \code{LUKASIEWICZ} means \eqn{(b < a ? 1 - a + b : 1)}.
\item \code{ZADEH} means \eqn{(a < 0.5 || 1 - a > b ? 1 - a : (a < b ? a : b))}.
\item \code{GOGUEN} means \eqn{(a < b ? 1 : b / a)}.
\item \code{GODEL} means \eqn{(a <= b ? 1 : b)}.
\item \code{SHARP} means \eqn{(a <= b ? 1 : 0)}.
\item \code{MIZUMOTO} means \eqn{(1 - a + a * b)}.
\item \code{DUBOIS_PRADE} means \eqn{(b == 0 ? 1 - a : (a == 1 ? b : 1))}.
\item \code{MIN} means \eqn{(a < b ? a : b)}.
}}

\item{classification}{a boolean representing whether it is a classification problem or not.}

\item{range.data}{a matrix representing interval of data.}
}
\description{
This is the internal function that implements the model proposed by L. X. Wang and J. M.
Mendel. It is used to solve regression task. Users do not need to call it directly,
but just use \code{\link{frbs.learn}} and \code{\link{predict}}
}
\details{
The fuzzy rule-based system for learning from L. X. Wang and J. M.
Mendel's paper is implemented in this function. For the learning process, there are four stages as follows:
\itemize{
\item \code{Step 1:} Divide equally the input and output spaces of the given numerical data into
     fuzzy regions as the database. In this case, fuzzy regions refers to intervals for each
     linguistic term. Therefore, the length of fuzzy regions represents the number of
     linguistic terms. For example, the linguistic term "hot" has the fuzzy region \eqn{[1, 3]}.
     We can construct a triangular membership function having the corner points
     \eqn{a = 1}, \eqn{b = 2}, and \eqn{c = 3} where \eqn{b} is a middle point
     that its degree of the membership function equals one.
\item \code{Step 2:} Generate fuzzy IF-THEN rules covering the training data,
     using the database from Step 1. First, we calculate degrees of the membership function
     for all values in the training data. For each instance in the training data,
     we determine a linguistic term having a maximum degree in each variable.
     Then, we repeat the process for each instance in the training data to construct
     fuzzy rules covering the training data.
\item \code{Step 3:} Determine a degree for each rule.
     Degrees of each rule are determined by aggregating the degree of membership functions in
     the antecedent and consequent parts. In this case, we are using the product aggregation operators.
\item \code{Step 4:} Obtain a final rule base after deleting redundant rules.
     Considering degrees of rules, we can delete the redundant rules having lower degrees.
}
The outcome is a Mamdani model. In the prediction phase,
there are four steps: fuzzification, checking the rules, inference, and defuzzification.
}
\references{
L. X. Wang and J. M. Mendel, "Generating fuzzy rule by learning from examples", IEEE Trans. Syst., Man, and Cybern.,
vol. 22, no. 6, pp. 1414 - 1427 (1992).
}
\seealso{
\code{\link{frbs.learn}}, \code{\link{predict}} and \code{\link{frbs.eng}}.
}

