% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticfragility.R
\name{logisticfragility}
\alias{logisticfragility}
\title{Logistic Fragility Function}
\usage{
logisticfragility(formula, data, covariate = "all.factors.default",
  conf.level = 0.95, verbose = FALSE)
}
\arguments{
\item{formula}{Model formula which will be evaluated by glm()}

\item{data}{Dataframe with values for model forma, passed to glm()}

\item{covariate}{Vector of covariates to find fragility index for. Default is all covariates in formula}

\item{conf.level}{Significance level}

\item{verbose}{Logical indicating if function will return verbose results or only fragility index}
}
\value{
If verbose is FALSE, returns a list with fragility indices for selected covariates. If
verbose is TRUE, returns a list with p-values for each fragility index
at each iteration of the algorithm.
}
\description{
Compute the fragility of a coefficient in a logistic regression for dichotomous outcomes, i.e. the number of removed observations it would take to make a significant-result non-significant. Uses the glm() function from the stats package.
}
\examples{
# Import and format example data
mydata <- read.csv("https://stats.idre.ucla.edu/stat/data/binary.csv")
mydata$rank <- factor(mydata$rank)

logisticfragility(admit ~ gre + gpa + rank, data = mydata, covariate="gpa", verbose = TRUE)

logisticfragility(admit ~ gre + gpa + rank, data = mydata)

}
