% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cover_metrics.R
\name{transect_summary}
\alias{transect_summary}
\title{Print a Summary of Cover-Weighted FQA Metrics}
\usage{
transect_summary(
  x,
  key = "name",
  db,
  cover_class = "percent_cover",
  allow_no_c = TRUE,
  plot_id = NULL
)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{cover_class}{a character string representing the cover classification used. Acceptable
cover classes are: \code{"percent_cover"}, \code{"carolina_veg_survey"}, \code{"braun-blanquet"},
\code{"daubenmire"}, and \code{"usfs_ecodata"}. \code{"percent_cover"} is the default.}

\item{allow_no_c}{Boolean (TRUE or FALSE). If TRUE, allow species that are found in the
regional FQA database but have not been assigned a C Values. If FALSE, omit species that have not
been assigned C Values.}

\item{plot_id}{A character string representing the column in \code{x} that contains plot
identification values. \code{plot_id} is a required argument in \code{plot_summary}, where it acts
as a grouping variable. \code{plot_id} is optional but highly recommended for
cover-weighted functions and relative functions. If \code{plot_id} is set in a
cover-weighted function or a relative function, it only prevents duplicates
from occurring in the same plot. It does not act as a grouping variable.}
}
\value{
A data frame
}
\description{
\code{transect_summary} calculates and prints a summary of both inventory
metrics and cover-weighted metrics, including Species Richness, Native Species
Richness, Introduced Species Richness, \% of species within C value ranges,
Mean C, Native Mean C, Cover-weighted Mean C, Native Cover-Weighted Mean C,
Total FQI, Native FQI, Cover-Weighted FQI, Native Cover-weighted FQI, Adjusted
FQI, Mean Wetness, Native Mean Wetness and \% Hydrophytes. Cover-weighted
metrics allow duplicate entries for transect level summary metrics.
}
\examples{
transect <- data.frame(
acronym  = c("ABEESC", "ABIBAL", "AMMBRE", "ANTELE", "ABEESC", "ABIBAL", "AMMBRE"),
cover = c(50, 4, 20, 30, 40, 7, 60),
plot_id = c(1, 1, 1, 1, 2, 2, 2))

transect_summary(x = transect, key = "acronym", db = "michigan_2014",
plot_id = "plot_id")
}
