% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqi_metrics.R
\name{adjusted_FQI}
\alias{adjusted_FQI}
\title{Calculate Adjusted FQI}
\usage{
adjusted_FQI(x, key = "name", db)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}
}
\value{
A non-negative integer
}
\description{
\code{adjusted_FQI} calculates the Adjusted Floristic Quality Index. Adjusted FQI
is found by multiplying 100 by the Native Mean C divided by 10 and then multiplied
by the square root of Native Species Richness over Total Species Richness.
}
\examples{
plant_list <- crooked_island
adjusted_FQI(x = plant_list, key = "acronym", db = "michigan_2014")
}
