% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{datasets.upload_files}
\alias{datasets.upload_files}
\title{Upload a local file or folder to a Foundry Dataset.}
\usage{
datasets.upload_files(files, alias)
}
\arguments{
\item{files}{The local files and folders to upload.
If a folder is provided, all files found recursively in subfolders will be uploaded.}

\item{alias}{The alias representing the Dataset.}
}
\value{
A list mapping local file paths to the corresponding Foundry Dataset file.
}
\description{
Upload a local file or folder to a Foundry Dataset.
}
\examples{
\dontrun{
# Upload RDS files to a Dataset
local_dir <- file.path(tempdir(), "to_upload")
dir.create(local_dir)
saveRDS(iris, file.path(local_dir, "iris.rds"))
saveRDS(Titanic, file.path(local_dir, "Titanic.rds"))

datasets.upload_files(local_dir, "my_output")
}

}
