% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_forestly.R
\name{ae_forestly}
\alias{ae_forestly}
\title{Display interactive forest plot}
\usage{
ae_forestly(outdata, filter = c("prop", "n"), width = 1400)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=format_ae_forestly]{format_ae_forestly()}}.}

\item{filter}{A character value of the filter variable.}

\item{width}{A numeric value of width of the table in pixels.}
}
\value{
An AE forest plot saved as a \code{shiny.tag.list} object.
}
\description{
Display interactive forest plot
}
\examples{
adsl <- forestly_adsl[1:100, ]
adae <- forestly_adae[1:100, ]
if (interactive()) {
  meta_forestly(
    dataset_adsl = adsl,
    dataset_adae = adae,
    population_term = "apat",
    observation_term = "wk12"
  ) |>
    prepare_ae_forestly(parameter = "any;rel") |>
    format_ae_forestly() |>
    ae_forestly()
}
}
