% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_deeplearning_utils.R
\name{tskeras}
\alias{tskeras}
\title{keras model for time series.}
\usage{
tskeras(x, model, lag = 1, batch_size = 1, epochs = 20, verbose = 0)
}
\arguments{
\item{x}{a ts object.}

\item{model}{a keras model.}

\item{lag}{indicates by value to test alpha, beta and gamma.}

\item{batch_size}{indicates by value to test alpha, beta and gamma.}

\item{epochs}{indicates by value to test alpha, beta and gamma.}

\item{verbose}{indicates by value to test alpha, beta and gamma.}
}
\value{
keras model
}
\description{
keras model for time series.
}
\examples{
\donttest{
  library(keras)
  modelo.deep <- keras_model_sequential() \%>\% 
  layer_lstm(
    units = 10, activation = 'tanh', batch_input_shape = c(1, 12, 1),
    return_sequences = TRUE, stateful = TRUE) \%>\%
  layer_dense(units = 1) \%>\%
  compile(loss = 'mse', optimizer = 'adam', metrics = 'mse')
  tskeras(AirPassengers, modelo.deep, lag = 12, epochs = 1)
}

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
