% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{na.interp}
\alias{na.interp}
\title{Interpolate missing values in a time series}
\usage{
na.interp(x, lambda = NULL)
}
\arguments{
\item{x}{time series}

\item{lambda}{a numeric value suggesting Box-cox transformation}
}
\value{
Time series
}
\description{
Uses linear interpolation for non-seasonal series and a periodic stl
decomposition with seasonal series to replace missing values.
}
\details{
A more general and flexible approach is available using \code{na.approx} in
the \code{zoo} package.
}
\examples{

data(gold)
plot(na.interp(gold))

}
\seealso{
\code{\link[forecast]{tsoutliers}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
