% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{solve_cg}
\alias{solve_cg}
\title{Iteratively Solve a Linear System with Conjugate Gradient}
\usage{
solve_cg(l, b, init, args)
}
\arguments{
\item{l}{A linear transformation of \eqn{x}.}

\item{b}{A vector.}

\item{init}{Initial value of solution.}

\item{args}{List of additional arguments from \code{cg_args}.}
}
\value{
A list with the form of a \code{solve_cg_result} described in section "Conjugate
Gradient" of the package vignette.
}
\description{
Solve the system \eqn{l(x) = b} where \eqn{l(x)} is a matrix-free
representation of the linear operation \eqn{Ax}.
}
\examples{
set.seed(1234)

n = 8
idx_diag = cbind(1:n, 1:n)
idx_ldiag = cbind(2:n, 1:(n-1))
idx_udiag = cbind(1:(n-1), 2:n)
b = rep(1, n)

## Solution by explicit computation of solve(A, b)
A = matrix(0, n, n)
A[idx_diag] = 2
A[idx_ldiag] = 1
A[idx_udiag] = 1
solve(A, b)

## Solve iteratively with solve_cg
f = function(x) { A \%*\% x }
args = cg_args()
init = rep(0, n)
solve_cg(f, b, init, args)

}
