% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fmt_quantile_range}
\alias{fmt_quantile_range}
\title{Formatted Quantile Range}
\usage{
fmt_quantile_range(x, format = "\%.1f", sep = "-", lower = 0.25, upper = 0.75)
}
\arguments{
\item{x}{The input data vector or data frame column.}

\item{format}{A formatting string suitable for input into the 
\code{\link[base]{sprintf}} function.  By default, this format is
defined as "\%.1f", which displays the value with one decimal place.}

\item{sep}{The character to use as a separator between the two quantiles.}

\item{lower}{The lower quantile range.  Default is .25.}

\item{upper}{The upper quantile range.  Default is .75.}
}
\value{
The formatted quantile range.
}
\description{
A function to calculate and format a quantile range.
}
\details{
This function calculates a quantile range using the stats package
\code{\link[stats]{quantile}}
function, and then formats the output using \code{\link[base]{sprintf}}.
You may control the format using the \strong{format} parameter.  Function will 
ignore any NA values in the input data. Results are returned as a 
character vector. 

By default, the function calculates the 1st and 3rd quantiles at .25 and .75.
The upper and lower quantile ranges may be changed with the \code{upper}
and \code{lower} parameters.
}
\examples{
# Create example vector
v1 <- c(4.3, 3.7, 8.7, 6.1, 9.2, 5.6, NA, 0.7, 7.8, 4.9)

# Format Quantiles
fmt_quantile_range(v1)

# Output
# "4.3 - 7.8"
}
\seealso{
Other helpers: 
\code{\link{fmt_cnt_pct}()},
\code{\link{fmt_mean_sd}()},
\code{\link{fmt_median}()},
\code{\link{fmt_n}()},
\code{\link{fmt_range}()}
}
\concept{helpers}
