% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fattr.R
\name{fattr}
\alias{fattr}
\title{Set formatting attributes}
\usage{
fattr(
  x,
  format = NULL,
  width = NULL,
  justify = NULL,
  label = NULL,
  description = NULL,
  keep = TRUE
)
}
\arguments{
\item{x}{The vector or data frame column to assign attributes to.}

\item{format}{The format to assign to the format attribute.  The format 
can be a formatting string, a named vector decode, a vectorized
formatting function, or a formatting list.}

\item{width}{The desired width of the formatted output.}

\item{justify}{Justification of the output vector. Valid values are 
'none', 'left', 'right', 'center', or 'centre'.}

\item{label}{A label string to assign to the vector.  This parameter 
was added for convenience, as the label is frequently assigned at the 
same time the formatting attributes are assigned.}

\item{description}{A description string to assign to the vector. This parameter 
was added for convenience, as the description is frequently assigned at the 
same time the formatting attributes are assigned.}

\item{keep}{Whether to keep any existing formatting attributes and 
transfer to the new vector.  Default value is TRUE.}
}
\value{
The vector with formatting attributes assigned.
}
\description{
Assign formatting attributes to a vector.
}
\details{
The \code{fattr} function is a convenience function for assigning 
formatting attributes to a vector.  The function accepts parameters
for format, width, and justify.  Any formatting attributes assigned 
can be applied using \code{\link{fapply}} or
\code{\link{fdata}}.
}
\examples{
# Create vector
a <- c(1.3243, 5.9783, 2.3848)

# Assign format attributes
a <- fattr(a, format = "\%.1f", width = 10, justify = "center")

# Apply format attributes
fapply(a)

# [1] "   1.3    " "   6.0    " "   2.4    "
}
\seealso{
\code{\link{fdata}} to apply formats to a data frame, 
 \code{\link{fapply}} to apply formats to a vector.  See
\link{FormattingStrings} for documentation on formatting strings.
}
