% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ame.R
\name{AverageMarginalEffects}
\alias{AverageMarginalEffects}
\title{R6 Class computing Average Marginal Effects (AME) based on Forward Marginal Effects (FME) for a model}
\description{
The AME is a simple mean FME and computed w.r.t. a feature variable and a model.
}
\examples{

## ------------------------------------------------
## Method `AverageMarginalEffects$new`
## ------------------------------------------------

# Train a model:

library(mlr3verse)
library(ranger)
set.seed(123)
data(bikes, package = "fmeffects")
row.id = sample(1:nrow(bikes), 100)
task = as_task_regr(x = bikes, id = "bikes", target = "count")
forest = lrn("regr.ranger")$train(task)

# Compute AMEs for all features:
overview = AverageMarginalEffects$new(
  model = forest,
  data = bikes[row.id, ],
  target = "count")$compute()
summary(overview)

# Compute AMEs for a subset of features with non-default step.sizes:
overview = AverageMarginalEffects$new(model = forest,
                                      data = bikes[row.id, ],
                                      target = "count",
                                      features = c(humidity = 0.1,
                                                   weather = c("clear", "rain")))$compute()
summary(overview)

## ------------------------------------------------
## Method `AverageMarginalEffects$compute`
## ------------------------------------------------

# Compute results:
overview$compute()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{predictor}}{\code{Predictor} object}

\item{\code{features}}{vector of features for which AMEs should be computed}

\item{\code{ep.method}}{string specifying extrapolation detection method}

\item{\code{results}}{data.table with AMEs computed}

\item{\code{computed}}{logical specifying if compute() has been run}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AverageMarginalEffects-new}{\code{AverageMarginalEffects$new()}}
\item \href{#method-AverageMarginalEffects-compute}{\code{AverageMarginalEffects$compute()}}
\item \href{#method-AverageMarginalEffects-clone}{\code{AverageMarginalEffects$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AverageMarginalEffects-new"></a>}}
\if{latex}{\out{\hypertarget{method-AverageMarginalEffects-new}{}}}
\subsection{Method \code{new()}}{
Create a new AME object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AverageMarginalEffects$new(
  model,
  data,
  target,
  features = NULL,
  ep.method = "none"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{The (trained) model, with the ability to predict on new data. This must be an \code{Learner} (\code{mlr3}) or \code{train} (\code{caret}) object.}

\item{\code{data}}{The data used for computing AMEs, must be data.frame or data.table.}

\item{\code{target}}{A string specifying the model's target variable.}

\item{\code{features}}{A named character vector of the names of the feature variables for which AMEs should be computed, together with the desired step sizes.}

\item{\code{ep.method}}{String specifying the method used for extrapolation detection. One of \code{"none"} or \code{"envelope"}. Defaults to \code{"none"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AME} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Train a model:

library(mlr3verse)
library(ranger)
set.seed(123)
data(bikes, package = "fmeffects")
row.id = sample(1:nrow(bikes), 100)
task = as_task_regr(x = bikes, id = "bikes", target = "count")
forest = lrn("regr.ranger")$train(task)

# Compute AMEs for all features:
overview = AverageMarginalEffects$new(
  model = forest,
  data = bikes[row.id, ],
  target = "count")$compute()
summary(overview)

# Compute AMEs for a subset of features with non-default step.sizes:
overview = AverageMarginalEffects$new(model = forest,
                                      data = bikes[row.id, ],
                                      target = "count",
                                      features = c(humidity = 0.1,
                                                   weather = c("clear", "rain")))$compute()
summary(overview)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AverageMarginalEffects-compute"></a>}}
\if{latex}{\out{\hypertarget{method-AverageMarginalEffects-compute}{}}}
\subsection{Method \code{compute()}}{
Computes results, i.e., AMEs including the SD of FMEs, for an \code{AME} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AverageMarginalEffects$compute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{AME} object with results.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Compute results:
overview$compute()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AverageMarginalEffects-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AverageMarginalEffects-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AverageMarginalEffects$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
