% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{actual_365}
\alias{actual_365}
\title{The years between two dates using the actual/365 (fixed) day basis
convention.}
\usage{
actual_365(date1, date2)
}
\arguments{
\item{date1}{A date-time object}

\item{date2}{A date-time object}
}
\value{
a numeric value representing the number of years between
\code{date1} and \code{date2}.
}
\description{
This calculates the years between two dates using the actual/365 (fixed)
day  basis convention. This convention counts the number of calendars
between the start and end dates and assumes a year consists of 365 days.
This is also known as the Act/365 fixed, A/365 fixed, A/365F and English
day basis convention.
}
\details{
The year fraction is calculated as:
\deqn{\frac{Number of calendar days}{365}}

The order of \code{date1} and \code{date2} is not important. If \code{date1}
is less than \code{date2} then the result will be non-negative. Otherwise,
the result will be negative.
}
\keyword{internal}
