% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality.R
\name{flux_quality}
\alias{flux_quality}
\title{assessing quality of slopes calculated with flux_fitting}
\usage{
flux_quality(
  slopes_df,
  conc_col,
  f_fluxid = f_fluxid,
  f_slope = f_slope,
  f_time = f_time,
  f_start = f_start,
  f_end = f_end,
  f_fit = f_fit,
  f_cut = f_cut,
  f_pvalue = f_pvalue,
  f_rsquared = f_rsquared,
  f_b = f_b,
  force_discard = c(),
  force_ok = c(),
  ratio_threshold = 0,
  fit_type = c(),
  ambient_conc = 421,
  error = 100,
  pvalue_threshold = 0.3,
  rsquared_threshold = 0.7,
  rmse_threshold = 25,
  cor_threshold = 0.5,
  b_threshold = 1,
  cut_arg = "cut"
)
}
\arguments{
\item{slopes_df}{dataset containing slopes}

\item{conc_col}{column containing the measured gas concentration
(exponential fit)}

\item{f_fluxid}{column containing unique IDs for each flux}

\item{f_slope}{column containing the slope of each flux
(as calculated by the flux_fitting function)}

\item{f_time}{column containing the time of each measurement in seconds
(exponential fit)}

\item{f_start}{column with datetime of the start of the measurement
(after cuts)}

\item{f_end}{column with datetime of the end of the measurement
(after cuts)}

\item{f_fit}{column containing the modeled data (exponential fit)}

\item{f_cut}{column containing the cutting information}

\item{f_pvalue}{column containing the p-value of each flux
(linear and quadratic fit)}

\item{f_rsquared}{column containing the r squared of each flux
(linear and quadratic fit)}

\item{f_b}{column containing the b parameter of the exponential expression
(exponential fit)}

\item{force_discard}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{ratio_threshold}{ratio of gas concentration data points over length of
measurement (in seconds) below which the measurement will be considered as
not having enough data points to be considered for calculations}

\item{fit_type}{model fitted to the data, linear, quadratic or exponential.
Will be automatically filled if slopes_df was produced using flux_fitting()}

\item{ambient_conc}{ambient gas concentration in ppm at the site of
measurement (used to detect measurement that started with a polluted setup)}

\item{error}{error of the setup, defines a window outside of which
the starting values indicate a polluted setup}

\item{pvalue_threshold}{threshold of p-value below which the change of
gas concentration over time is considered not significant
(linear and quadratic fit)}

\item{rsquared_threshold}{threshold of r squared value below which
the linear model is considered an unsatisfactory fit
(linear and quadratic fit)}

\item{rmse_threshold}{threshold for the RMSE of each flux above which
the fit is considered unsatisfactory (exponential fit)}

\item{cor_threshold}{threshold for the correlation coefficient of
gas concentration with time below which the correlation
is considered not significant (exponential fit)}

\item{b_threshold}{threshold for the b parameter.
Defines a window with its opposite inside which the fit is
considered good enough (exponential fit)}

\item{cut_arg}{argument defining that the data point should be cut out}
}
\value{
a dataframe with added columns of quality flags (\code{f_quality_flag}),
the slope corrected according to the quality flags (\code{f_slope_corr}),
some diagnostics depending on the fit, and any columns present in the input.
}
\description{
indicates if slopes should be discarded or replaced
by 0 according to quality thresholds set by user
}
\examples{
data(slopes0lin)
flux_quality(slopes0lin, conc, fit_type = "li")
data(slopes30)
flux_quality(slopes30, conc, fit_type = "expo")
}
