% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_make_data.r
\name{makeInpData}
\alias{makeInpData}
\title{Generate a matrix style data for simulation}
\usage{
makeInpData(
  N,
  R2Y,
  R2eta,
  omega,
  tau0,
  tau1,
  betaL,
  betaY,
  linear = TRUE,
  ydist = "n",
  lambda,
  nitem,
  nfac = 1,
  lvmodel,
  fcovmat,
  item.missing = TRUE,
  misspec = FALSE,
  cov.res = 0,
  relsize = 0.6
)
}
\arguments{
\item{N}{a numeric indicating sample size.}

\item{R2Y}{a numeric indicating predictive power of covariates.}

\item{R2eta}{a numeric indicating Predictive power of latent variable}

\item{omega}{a numeric indicating the size of effect of latent factor on
the outcome.}

\item{tau0}{a numeric indicating the size of difference in the outcome
between the treatment and the control.}

\item{tau1}{a numeric indicating the principal effect}

\item{betaL}{a numeric vector indicating the effects of covariates on the latent factor}

\item{betaY}{a numeric vector indicating the effects of covariates on the outcome}

\item{linear}{a logical whether the relationship between the outcome and covariates is linear (default is \code{TRUE}).}

\item{ydist}{a character indicating the outcome distribution (default is \code{n}).}

\item{lambda}{a numeric indicating the mean of Worked problems/person.
(extent to which covariates predict eta).}

\item{nitem}{a numeric indicating the number of maximum measurement items
given to students.}

\item{nfac}{a numeric indicating the number of latent factors}

\item{lvmodel}{a character specifying a type of latent variable model.}

\item{fcovmat}{a matrix indicating the variance-covariance matrix of latent
factors when nfac > 1}

\item{item.missing}{a logical to make the measurement item data missing for
the control group (default is \code{TRUE}).}

\item{misspec}{a logical to allow cross-loadings across latent factors
when nfac > 1 (default is \code{FALSE}).}

\item{cov.res}{a logical to allow for residual correlations
(only for CFA model) (default is \code{0}).}

\item{relsize}{a numeric indicating the degree to which the latent factor explain the variances of continuous items (only for CFA model) (default is \code{0.6}).}
}
\value{
a list containing all the data related to population values and running FLPS.
}
\description{
\code{\link{makeInpData}} is a function for generating a data based on
the given information.
}
\examples{
sdat <- makeInpData(
N       = 200,  # sample size
R2Y     = 0.2,  # r^2 of outcome
R2eta   = 0.5,  # r^2 of eta by one covariates
omega   = 0.2,  # the effect of eta
tau0    = 0.13, # direct effect
tau1    = -0.06,# interaction effect between Z and eta
betaL   = 0.2,
betaY   = 0.4,
lambda  = 0.8,  # the proportion of administered items
nitem    = 10,   # the total number of items
nfac    = 1,    # the number of latent factors
lvmodel = '2pl' )
}
