% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\alias{mk_par}
\title{Define flextable displayed values}
\usage{
compose(x, i = NULL, j = NULL, value, part = "body")

mk_par(x, i = NULL, j = NULL, value, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{column selection}

\item{value}{a call to function \code{\link[=as_paragraph]{as_paragraph()}}.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Modify flextable displayed values. Function is
handling complex formatting as well as image insertion.

Function \code{mk_par} is another name for \code{compose} as
there is an unwanted conflict with package \code{purrr}.
}
\section{Illustrations}{


\if{html}{\figure{fig_compose_1.png}{options: width=80\%}}
}

\examples{
library(officer)
ft <- flextable(head( mtcars, n = 10))
ft <- compose(ft, j = "carb", i = ~ drat > 3.5,
  value = as_paragraph("carb is ", as_chunk( sprintf("\%.1f", carb)) )
  )
ft <- autofit(ft)
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_date}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
